<?php

namespace Sqits\Dropbox\Resources\Concerns;

use Http\Discovery\Psr17FactoryDiscovery;
use Psr\Http\Message\RequestInterface;
use Sqits\Dropbox\DropboxClient;

trait CanUseClient
{
    protected DropboxClient $client;

    public function __construct(DropboxClient $client)
    {
        $this->client = $client;
    }

    public function buildRequest(string $method, string $uri, array $parameters = []): RequestInterface
    {
        return Psr17FactoryDiscovery::findRequestFactory()
            ->createRequest($method, $uri);
    }

    public function buildRequestWithArgs(string $method, string $uri, array $args = []): RequestInterface
    {
        return Psr17FactoryDiscovery::findRequestFactory()
            ->createRequest($method, $uri)
            ->withHeader('Dropbox-API-Arg', json_encode($args));
    }
}
