<?php

namespace Sqits\Dropbox\Factories;

use Http\Client\Common\Plugin;
use Http\Client\Common\Plugin\AuthenticationPlugin;
use Http\Client\Common\Plugin\HeaderDefaultsPlugin;
use Http\Message\Authentication\Bearer;

class PluginFactory
{
    /**
     * @param string $token
     * @return array<int,Plugin>
     */
    public static function default(string $token): array
    {
        return [
            new AuthenticationPlugin(
                new Bearer($token)
            ),
            new HeaderDefaultsPlugin(
                [
                    'user-agent' => 'dropBox_php_client',
                    'Content-Type' => 'application/json',
                ]
            )
        ];
    }
}
