<?php

namespace Sqits\Dropbox;

use Http\Client\Common\PluginClient;
use Http\Discovery\Psr18ClientDiscovery;
use Psr\Http\Client\ClientExceptionInterface;
use Psr\Http\Client\ClientInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Sqits\Dropbox\Factories\PluginFactory;
use Sqits\Dropbox\Resources\FileResource;
use Sqits\Dropbox\Resources\FolderResource;
use Sqits\Dropbox\Resources\MetadataResource;

class DropboxClient implements Contracts\ClientContract
{
    /**
     * @var array{
     *     apiKey: string,
     * } $config
     */
    public array $config;

    public ClientInterface $http;

    /**
     * @param array{
     *     apiKey: string,
     * } $config
     * @param ClientInterface $httpClient
     */
    public function __construct(array $config, ClientInterface $httpClient)
    {
        $this->config = $config;
        $this->http = $httpClient;
    }

    /**
     * @param array{
     *     apiKey: string,
     * } $config
     * @return DropboxClient
     */
    public static function client(array $config): DropboxClient
    {
        $client = new PluginClient(
            Psr18ClientDiscovery::find(),
            PluginFactory::default(
                $config['apiKey']
            )
        );

        return new DropboxClient(
            $config,
            $client
        );
    }

    public function files(): FileResource
    {
        return new FileResource($this);
    }

    public function folder(): FolderResource
    {
        return new FolderResource($this);
    }

    public function metadata(): MetadataResource
    {
        return new MetadataResource($this);
    }

    /**
     * @throws ClientExceptionInterface
     */
    public function send(RequestInterface $request): ResponseInterface
    {
        return $this->http->sendRequest($request);
    }
}
