<?php

namespace Sqits\Dropbox\DataObjects;

class Metadata
{
    public string $tag;
    public string $name;
    public string $path_lower;
    public string $path_display;
    public string $id;
    public ?string $client_modified;
    public ?string $server_modified;
    public ?string $rev;
    public ?int $size;
    public ?bool $is_downloadable;
    public ?string $content_hash;

    /**
     * @var array{
     *  created: ?string,
     *  is_lockholder: ?bool,
     *  lockholder_name: ?string
     * }|null $file_lock_info
     */
    public ?array $file_lock_info;

    public ?bool $has_explicit_shared_members;


    /**
     * @var array{
     *  fields: array{
     *      name: string,
     *      value: string
     *  },
     *  template_id: string
     * }|null $property_groups
     */
    public ?array $property_groups;

    /**
     * @var array{
     *  modified_by: string,
     *  parent_shared_folder_id: string,
     *  read_only: bool,
     * }|null $sharing_info
     */
    public ?array $sharing_info;


    public function __construct(
        string  $tag,
        string  $name,
        string  $path_lower,
        string  $path_display,
        string  $id,
        ?string $client_modified = null,
        ?string $server_modified = null,
        ?string $rev = null,
        ?int    $size = null,
        ?bool   $is_downloadable = null,
        ?string $content_hash = null,
        ?array  $file_lock_info = null,
        ?bool   $has_explicit_shared_members = null,
        ?array  $property_groups = null,
        ?array  $sharing_info = []

    )
    {
        $this->tag = $tag;
        $this->client_modified = $client_modified;
        $this->content_hash = $content_hash;
        $this->file_lock_info = $file_lock_info;
        $this->has_explicit_shared_members = $has_explicit_shared_members;
        $this->id = $id;
        $this->is_downloadable = $is_downloadable;
        $this->name = $name;
        $this->path_display = $path_display;
        $this->path_lower = $path_lower;
        $this->property_groups = $property_groups;
        $this->rev = $rev;
        $this->server_modified = $server_modified;
        $this->sharing_info = $sharing_info ?? null;
        $this->size = $size;
    }

    /*
     * @param array<string,mixed> $data
     */
    /**
     * @param array{
     *      ".tag": string,
     *      "name": string,
     *      "path_lower": string,
     *      "path_display": string,
     *      "id": string,
     *      "client_modified": string|null,
     *      "server_modified": string|null,
     *      "rev": string|null,
     *      "size": int|null,
     *      "is_downloadable": bool|null,
     *      "content_hash": string|null,
     *      "file_lock_info": array{
     *           created: string,
     *           is_lockholder: bool,
     *           lockholder_name: string
     *      }|null,
     *      "has_explicit_shared_members": bool|null,
     *      "property_groups": array{
     *          name: string,
     *          value: string
     *      }|null,
     *      "sharing_info": array{
     *           modified_by: string,
     *           parent_shared_folder_id: string,
     *           read_only: bool
     *      }|null
     *  } $data
     * /
     * @return Metadata
     */
    public static function fromResponse(array $data): Metadata
    {
        return new Metadata(
            $data['.tag'],
            $data['name'],
            $data['path_lower'],
            $data['path_display'],
            $data['id'],
            $data['client_modified'] ?? null,
            $data['server_modified'] ?? null,
            $data['rev'] ?? null,
            $data['size'] ?? null,
            $data['is_downloadable'] ?? null,
            $data['content_hash'] ?? null,
            $data['file_lock_info'] ?? null,
            $data['has_explicit_shared_members'] ?? null,
            $data['property_groups'] ?? null,
            $data['sharing_info']?? [],
        );
    }
}
