<?php

namespace Sqits\Dropbox\DataObjects;

class File
{
    public string $path;

    public string $client_modified;
    public string $content_hash;
    public ?bool $has_explicit_shared_members;
    public string $id;
    public bool $is_downloadable;
    public string $name;
    public string $path_display;
    public string $path_lower;
    public string $rev;
    public string $server_modified;
    public int $size;

    /**
     * @var array{
     *  created: ?string,
     *  is_lockholder: ?bool,
     *  lockholder_name: ?string
     * }|null $file_lock_info
     */
    public ?array $file_lock_info;

    /**
     * @var array{
     *  fields: array{
     *      name: string,
     *      value: string
     *  },
     *  template_id: string
     * }|null $property_groups
     */
    public ?array $property_groups;

    /**
     * @var array{
     *  modified_by: string,
     *  parent_shared_folder_id: string,
     *  read_only: bool,
     * }|null $sharing_info
     */
    public ?array $sharing_info;

    public function __construct(
        string $name,
        string $path_lower,
        string $path_display,
        string $id,
        string $client_modified,
        string $server_modified,
        string $rev,
        int    $size,
        bool   $is_downloadable,
        string $content_hash,
        ?bool  $has_explicit_shared_members = null,
        ?array $file_lock_info = [],
        ?array $property_groups = [],
        ?array $sharing_info = []
    )
    {
        $this->client_modified = $client_modified;
        $this->content_hash = $content_hash;
        $this->has_explicit_shared_members = $has_explicit_shared_members;
        $this->id = $id;
        $this->is_downloadable = $is_downloadable;
        $this->name = $name;
        $this->path_display = $path_display;
        $this->path_lower = $path_lower;
        $this->rev = $rev;
        $this->server_modified = $server_modified;
        $this->size = $size;
        $this->file_lock_info = $file_lock_info;
        $this->property_groups = $property_groups;
        $this->sharing_info = $sharing_info;
    }

    /**
     * @param array{
     *     client_modified: string,
     *     content_hash: string,
     *     has_explicit_shared_members: ?bool,
     *     id: string,
     *     is_downloadable: bool,
     *     name: string,
     *     path_display: string,
     *     path_lower: string,
     *     rev: string,
     *     server_modified: string,
     *     size: int,
     *     file_lock_info: array{
     *     created: ?string,
     *     is_lockholder: ?bool,
     *     lockholder_name: ?string
     *    }|null,
     *     property_groups: array{
     *     fields: array{
     *     name: string,
     *     value: string
     *   },
     *     template_id: string
     *  }|null,
     *     sharing_info: array{
     *     modified_by: string,
     *     parent_shared_folder_id: string,
     *     read_only: bool,
     *     }|null
     * } $data
     * @return File
     */
    public static function fromResponse(array $data): File
    {
        return new File(
            $data['name'],
            $data['path_lower'],
            $data['path_display'],
            $data['id'],
            $data['client_modified'],
            $data['server_modified'],
            $data['rev'],
            $data['size'],
            $data['is_downloadable'],
            $data['content_hash'],
            $data['has_explicit_shared_members'] ?? null,
            $data['file_lock_info'] ?? [],
            $data['property_groups'] ?? [],
            $data['sharing_info'] ?? []
        );
    }

}
