<?php

namespace Sqits\Dropbox\Contracts;

use Psr\Http\Client\ClientInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;

interface ClientContract
{

    /**
     * Create a new SDK Client.
     *
     * @param array{
     *     apiKey: string,
     * } $config
     * @param ClientInterface $client
     */
    public function __construct(array $config, ClientInterface $client);

    /**
     * Set the HTTP Client for the SDK Client.
     *
     * @param array{
     *     apiKey: string,
     * } $config
     * @return ClientContract
     */
    public static function client(array $config): ClientContract;
    public function send(RequestInterface $request): ResponseInterface;
}
