<?php

namespace Sqits\Dropbox;

class Config
{
    public string $apiKey;

    /**
     * @param string $apiKey
     */
    public function __construct($apiKey)
    {
        $this->apiKey = $apiKey;
    }

    /**
     * @param array{
     *     apiKey: string,
     * } $data
     * @return Config
     */
    public static function fromArray(array $data): Config
    {
        return new Config(
            $data['apiKey'],
        );
    }

    /**
     * @return array{
     *     apiKey: string,
     * }
     */
    public function toArray(): array
    {
        return [
            'apiKey' => $this->apiKey,
        ];
    }
}
