const mix = require("laravel-mix");
const path = require('path');
mix
    .setPublicPath("public")
    .js("resources/js/app.js", "public/js")
    .vue({version: 3})
    .postCss("resources/css/app.css", "public/css")
    .webpackConfig({
        resolve: {
            symlinks: false,
            alias: {
                '@': path.resolve(__dirname, 'resources/js/'),
            },
        }
    })
    .version();

if (mix.inProduction()) {
    mix.version();
}
