<?php

namespace Flex\TranslationManager;

use Flex\TranslationManager\Commands\InstallCommand;
use Flex\TranslationManager\Commands\TranslationManagerCommand;
use Flex\TranslationManager\Commands\TranslationSyncCommand;
use Illuminate\Support\Facades\Route;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class TranslationManagerServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('translation-manager')
            ->hasConfigFile()
            ->hasViews()
            ->hasMigration('create_translation_languages_table')
            ->hasMigration('create_translations_table')
//            ->hasCommand(TranslationManagerCommand::class)
            ->hasCommand(InstallCommand::class)
            ->hasCommand(TranslationSyncCommand::class);
    }

    public function packageRegistered()
    {
        if (! defined('TRANSLATION_MANAGER_PATH')) {
            define('TRANSLATION_MANAGER_PATH', realpath(__DIR__.'/../'));
        }
        $this->registerRoutes();
        $this->defineAssetPublishing();

    }

    public function defineAssetPublishing()
    {
        $this->publishes([
            TRANSLATION_MANAGER_PATH.'/public' => public_path('vendor/translation-manager'),
        ], 'translation-manager-assets');
    }

    protected function registerRoutes()
    {
        Route::group([
            'domain' => config('translation-manager.domain'),
            'prefix' => config('translation-manager.path'),
            'namespace' => 'Flex\TranslationManager\Http\Controllers',
            //            'middleware' => config('translation-manager.middleware'),
            'name' => 'translation-manager.',
        ], function () {
            $this->loadRoutesFrom(__DIR__.'/../routes/web.php');
            $this->loadRoutesFrom(__DIR__.'/../routes/api.php');
        });
    }
}
