<?php

namespace Flex\TranslationManager\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreUpdateTranslationRequest extends FormRequest
{
    public function rules(): array
    {
        if (config('translation-manager.use_multiple_files') === true) {
            $fileNameRule = ['required', 'string'];
        } else {
            $fileNameRule = ['nullable', 'string'];
        }

        return [
            'locale' => ['required', 'string'],
            'translation_key' => ['required', 'string'],
            'translation_value' => ['required', 'string'],
            'file_name' => $fileNameRule,
        ];
    }
}
