<?php

namespace Flex\TranslationManager\Http\Middleware;

use Closure;
use Flex\TranslationManager\Exceptions\ForbiddenException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class Authenticate
{
    public function handle(Request $request, Closure $next)
    {
        if (! Gate::check('viewTranslationManager', [$request->user()]) && ! app()->environment('local')) {
            throw ForbiddenException::make();
        }

        return $next($request);
    }
}
