<?php

namespace Flex\TranslationManager\Http\Controllers\Api;

class TranslationFileNameController
{
    public function index()
    {
        try {
            $currentFileNames = config('translation-manager.translation_model')::query()
                ->select(['file_name'])
                ->distinct('file_name')
                ->get()
                ->filter(function ($translation) {
                    return $translation->file_name;
                });

            return response()->json($currentFileNames);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Error fetching file names.',
            ], 422);
        }
    }
}
