<?php

namespace Flex\TranslationManager\Commands;

use Illuminate\Console\Command;

class PublishCommand extends Command
{
    public $signature = 'translation-manager:publish';

    public $description = 'Publish latest Translation Manager assets';

    public function handle(): int
    {
        $this->comment('Publishing Translation Manager Assets...');
        $this->callSilent('vendor:publish', ['--tag' => 'translation-manager-assets', '--force' => true]);

        return self::SUCCESS;
    }
}
