import {computed, ref} from "vue";
import {useState} from "@/composables/useState";


const deepClone = (obj) => {
    return JSON.parse(JSON.stringify(obj))
}

export function useModal(formDefault = {}) {
    const formDefaultValue = deepClone(formDefault)
    const {state, isLoading, setStateToIdle, setStateToPending} = useState()

    const active = ref(false)
    const toggleModal = () => {
        active.value = !active.value
        if (!active.value) {
            resetForm()
        }
    }

    const form = ref(formDefault)
    const errorRequest = ref({})
    const resetForm = () => {
        form.value = formDefaultValue
        errorRequest.value = {}
    }

     return {
        state,
        isLoading,
        setStateToPending,
        setStateToIdle,
        active,
        toggleModal,
        form,
        resetForm,
        errorRequest
    }
}
