<?php

namespace Flex\TranslationManager\Database\Factories;

use Flex\TranslationManager\Models\Translation;
use Flex\TranslationManager\Models\TranslationLanguage;
use Illuminate\Database\Eloquent\Factories\Factory;

class TranslationFactory extends Factory
{
    protected $model = Translation::class;

    public function definition()
    {
        return [
            'key' => $this->faker->unique()->word,
            'value' => $this->faker->unique()->word,
            'file_name' => 'test',
            'translation_language_id' => TranslationLanguage::factory()->create(),
        ];
    }

    public function withTestKey(): Factory
    {
        return $this->state(function (array $attributes) {
            return [
                'key' => 'test.'.fake()->unique()->word,
            ];
        });
    }
}
