# Laravel Translation Manager Package

Welcome to the Laravel Translation Manager package! Manage and streamline your translations effortlessly.

## Installation

Add the following in the repositories section of your composer.json file:

```json
{
    "repositories": [
        {
            "type": "composer",
            "url": "https://satis.flex-development.nl"
        }
    ]
}
```
Install the package via Composer:

```bash
composer require flex/translation-manager
```

After installation, publish the package assets using the "install" Artisan command:

```bash
php artisan translation-manager:install
```

The Translation Manager offers numerous configuration options. These can be adjusted in the `config/translation-manager.php` configuration file.

Run the migrations to set up the necessary database tables:

```bash
php artisan migrate
```

## Usage

The Translation Manager provides a dashboard at the /translation-manager URI. By default, access to this dashboard is restricted to the local environment. However, in your `app/Providers/AuthServiceProvider.php` file, you can add an authorization gate definition. Customize this gate example as needed to limit access to your Translation Manager installation:

```php
/**
* Register the Translation Manager gate.
*
* This gate determines who can access Translation Manager in non-local environments.
  */
  protected function gate(): void
    {
        Gate::define('viewTranslationManager', function ($user = null) {
            return in_array($user->email,[
                'example_user@translation-manager.com'
            ]);
        });
    }
```

## Testing

Run the tests with:

```bash
composer test
```

## Changelog

Refer to the [CHANGELOG](CHANGELOG.md) for recent changes.

## Contributing

See [CONTRIBUTING](CONTRIBUTING.md) for details.

## Security Vulnerabilities

Review [our security policy](../../security/policy) on reporting security vulnerabilities.

## Credits

- [Roderick Martina](https://github.com/roderick-martina)
- [All Contributors](../../contributors)

## License

