<?php

namespace Flex\TranslationManager\Http\Controllers\Api;

use Illuminate\Http\Request;

class TranslationKeyController
{
    public function index(Request $request)
    {
        $requestProperties = $request->validate([
            'locale' => ['required', 'string'],
            'search' => ['nullable', 'string'],
        ]);

        $locale = $requestProperties['locale'];
        $searchQuery = $requestProperties['search'] ?? '';

        $languageModel = config('translation-manager.translation_language_model');
        $languageModel = $languageModel::query()->where('name', $locale)->firstOrFail();

        $translationModel = config('translation-manager.translation_model');
        $translationQuery = $translationModel::query()
            ->select(['key', 'file_name'])
            ->distinct();

        if (strlen($searchQuery) > 0) {
            $translationQuery
                ->where('translation_language_id', $languageModel->id)
                ->where('key', 'like', "%{$searchQuery}%")
                ->orWhere('file_name', 'like', "%{$searchQuery}%")
                ->orWhere('value', 'like', "%{$searchQuery}%")
                ->orWhereRaw("CONCAT(`file_name`, '.', `key`) LIKE '%{$searchQuery}%'");
        }

        $translationKeys = $translationQuery->get()
            ->map(function ($translation) {
                return [
                    'key' => $translation->key,
                    'file_name' => $translation->file_name,
                    'display_key' => "{$translation->file_name}.{$translation->key}",
                ];
            });

        return response()->json([
            'translation_keys' => $translationKeys,
        ]);
    }
}
