<?php

// config for Flex/TranslationManager
return [

    /*
     * The model to use for the translations.
     */
    'translation_model' => \Flex\TranslationManager\Models\Translation::class,

    /*
     * The model to use for the translation languages.
     */
    'translation_language_model' => \Flex\TranslationManager\Models\TranslationLanguage::class,

    /*
     * This is the subdomain where the translation manager will be accessible.
     * if this is set to null, the translation manager will be accessible from the same domain as in the application.
     */
    'domain' => env('TRANSLATION_MANAGER_DOMAIN', null),

    /*
     * This is the uri path where translation manager will be accessible from.
     */
    'path' => env('TRANSLATION_MANAGER_PATH', 'translation-manager'),

    /*
     * This is the middleware that will be applied to the translation manager routes.
     */
    'middleware' => ['web'],

    /*
     * store translations in separate files within the language folder.
     */
    'separate_translation_files' => true,

    /*
     * If you want to increase the backup count, the package will keep the backups in the storage folder.
     * This option determines how many backups will be kept.
     */
    'backup_count' => 0,
];
