<?php

use Flex\TranslationManager\Http\Controllers\Api\LanguagesController;
use Flex\TranslationManager\Http\Controllers\Api\PublishTranslationController;
use Flex\TranslationManager\Http\Controllers\Api\TranslationKeyController;
use Flex\TranslationManager\Http\Controllers\Api\TranslationLanguageController;
use Illuminate\Support\Facades\Route;

Route::name('api')
    ->prefix('api')
    ->group(function () {
        Route::get('/translations', [TranslationLanguageController::class, 'index'])->name('translations.index');
        Route::put('/translations/{id}', [TranslationLanguageController::class, 'update'])->name('translations.update');
        Route::get('/translation-keys', [TranslationKeyController::class, 'index'])->name('translations.index');
        Route::get('/languages', [LanguagesController::class, 'index'])->name('lanauges.index');
        Route::post('/publish-translations', [PublishTranslationController::class, 'store'])->name('publish-translation.store');
    });
