import {notificationStore} from "@/store/notificationStore";
import NotificationTypeEnum from "@/enum/NotificationTypeEnum";


export function useNotification() {
    const resetNotificationData = () => {
        notificationStore.value.active = false
        notificationStore.value.data = {
            title: '',
            description: '',
            type: NotificationTypeEnum.SUCCESS,
        }
    }
    const createNotification = (title, description, type = NotificationTypeEnum.SUCCESS) => {
        notificationStore.value.data = {
            title,
            description,
            type,
        }
        notificationStore.value.active = true;
        setTimeout(resetNotificationData, 4000)
    }
    return {
        createNotification,
        resetNotificationData
    }
}
