import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import * as path from 'path'

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [vue()],
    build: {
        // generate .vite/manifest.json in outDir
        manifest: true,
        // assetsDir: "",
        rollupOptions: {
            // overwrite default .html entry
            input: path.join(__dirname, 'resources/js/main.ts')
        },
    },
    resolve: {
      alias: {
        '@': path.resolve(__dirname, '/resources/js'),
          // vue: 'vue/dist/vue.esm-bundler.js',

      }
    }
})
