<?php

namespace Flex\TranslationManager;

use Illuminate\Support\Facades\Gate;
use Illuminate\Support\ServiceProvider;

class TranslationManagerApplicationServiceProvider extends ServiceProvider
{
    public function boot()
    {
        $this->authorization();
    }

    public function authorization(): void
    {
        $this->gate();

        TranslationManager::auth(function ($request) {
            return Gate::check('viewTranslationManager', [$request->user()]) || app()->environment('local');
        });
    }

    protected function gate(): void
    {
        Gate::define('viewTranslationManager', function ($user = null) {
            return in_array($user->email, [
                //                'example_user@translation-manager.com'
            ]);
        });
    }
}
