<?php

namespace Flex\TranslationManager\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreUpdateTranslationRequest extends FormRequest
{
    public function rules(): array
    {
        $fileNameRequired = config('translation-manager.separate_translation_files');
        $rules = [
            'locale' => ['required', 'string'],
            'translation_key' => ['required', 'string'],
            'translation_value' => ['required', 'string'],
        ];

        if ($fileNameRequired) {
            $rules['file_name'] = ['required', 'string'];
        }

        return $rules;
    }
}
