<?php

namespace Flex\TranslationManager\Commands;

use Illuminate\Console\Command;

class InstallCommand extends Command
{
    public $signature = 'translation-manager:install';

    public $description = 'Install all of the Translation Manager resources';

    public function handle(): int
    {
        // temporary for development
        //        $target = __DIR__.'/../../public';
        //        $link = public_path('/vendor/translation-manager');
        //        if (! is tinker_dir($link)) {
        //            mkdir('public/vendor', 0777, true);
        //        }
        //        $this->laravel->make('files')->link($target, $link);
        $this->comment('Publishing Translation Manager Assets...');
        $this->callSilent('vendor:publish', ['--tag' => 'translation-manager-assets', '--force' => true]);

        $this->comment('Publishing Translation Manager Service provider...');
        $this->callSilent('vendor:publish', ['--tag' => 'translation-manager-provider', '--force' => true]);

        //        $this->registerTranslationManagerServiceProvider();

        $this->info('Translation Manager installed successfully.');

        return self::SUCCESS;
    }
}
