<?php

use Flex\TranslationManager\Http\Controllers\Api\LanguagesController;
use Flex\TranslationManager\Http\Controllers\Api\PublishTranslationController;
use Flex\TranslationManager\Http\Controllers\Api\SyncTranslationController;
use Flex\TranslationManager\Http\Controllers\Api\TranslationController;
use Flex\TranslationManager\Http\Controllers\Api\TranslationKeyController;
use Illuminate\Support\Facades\Route;

Route::name('api.')
    ->prefix('api')
    ->group(function () {
        // Translation Routes
        Route::get('/translations', [TranslationController::class, 'index'])->name('translations.index');
        Route::post('/translations', [TranslationController::class, 'store'])->name('translations.store');
        Route::put('/translations', [TranslationController::class, 'update'])->name('translations.update');
        Route::delete('/translations/{id}', [TranslationController::class, 'destroy'])->name('translations.destroy');

        // Translation Keys Routes
        Route::get('/translation-keys', [TranslationKeyController::class, 'index'])->name('translations.index');
        Route::delete('/translation-keys/{key}', [TranslationKeyController::class, 'destroy'])->name('translations.destroy');

        // Languages Routes
        Route::get('/languages', [LanguagesController::class, 'index'])->name('languages.index');
        Route::post('/languages', [LanguagesController::class, 'store'])->name('languages.store');
        Route::put('/languages/{id}', [LanguagesController::class, 'update'])->name('languages.update');
        Route::delete('/languages/{id}', [LanguagesController::class, 'destroy'])->name('languages.destroy');

        // Publish Translation Routes
        Route::post('/publish-translations', [PublishTranslationController::class, 'store'])->name('publish-translation.store');

        // Sync Translation Routes
        Route::post('/sync-translations', [SyncTranslationController::class, 'store'])->name('sync-translation.store');
    });
