<?php

namespace Flex\TranslationManager;

use Closure;
use Illuminate\Http\Request;

class TranslationManager
{

    /**
     * The callback that should be used to authenticate TranslationManager users.
     *
     * @var \Closure
     */
    public static Closure $authUsing;

    /**
     * Determine if the given request can access the Horizon dashboard.
     *
     * @param Request $request
     * @return bool
     */
    public static function check(Request $request): bool
    {
        return (static::$authUsing ?: function () {
            return app()->environment('local');
        })($request);
    }

    /**
     * Set the callback that should be used to authenticate Translation Managers users.
     *
     * @param  \Closure  $callback
     * @return static
     */
    public static function auth(Closure $callback): static
    {
        static::$authUsing = $callback;

        return new static;
    }
}
