<?php

namespace Flex\TranslationManager\Http\Middleware;

use Closure;
use Flex\TranslationManager\Exceptions\ForbiddenException;
use Flex\TranslationManager\TranslationManager;
use Illuminate\Http\Request;

class Authenticate
{
    public function handle(Request $request, Closure $next)
    {
        if (!TranslationManager::check($request)) {
            throw ForbiddenException::make();
        }

        return $next($request);
    }
}
