import {computed, ref} from "vue";
import StateEnum from "@/enum/StateEnum";


export function useState() {
    const state = ref(StateEnum.IDLE)
    const isLoading = computed(() => state.value === StateEnum.PENDING)
    const setStateToPending = () => state.value = StateEnum.PENDING
    const setStateToIdle = () => state.value = StateEnum.IDLE
    return {
        state,
        isLoading,
        setStateToPending,
        setStateToIdle,
    }
}
