<?php

namespace Flex\TranslationManager\Http\Controllers\Api;

use Illuminate\Support\Arr;
use Illuminate\Support\Str;

class PublishTranslationController
{
    public function store()
    {
        try {
            $useSeparateFiles = config('translation-manager.separate_translation_files');

            if ($useSeparateFiles) {
                $this->publishSeperateFiles();
            } else {
                $this->publishSingleFile();
            }

            return response()->json();
        } catch (\Exception $e) {
            report($e);

            return response()->json([
                'message' => 'Error publishing translations.',
            ], 422);
        }
    }

    private function publishSingleFile()
    {
        $fileName = 'app';
        $removeFileName = true; // make config option
        $languageModel = config('translation-manager.translation_language_model');
        foreach ($languageModel::query()->get() as $language) {
            $translations = $language->translations()->get()->mapWithKeys(function ($translation,$removeFileName) {
                if($removeFileName) {
                    return [$translation->key => $translation->value];
                }
                return ["{$translation->file_name}.{$translation->key}" => $translation->value];
            })->toArray();

            $this->generateFile($language, $fileName, $translations);
        }
    }

    private function publishSeperateFiles()
    {
        $languageModel = config('translation-manager.translation_language_model');
        foreach ($languageModel::query()->get() as $language) {
            $groupedTranslations = $language->translations()->get()->groupBy('file_name');
            foreach ($groupedTranslations as $fileName => $translationValues) {
                $translations = [];
                foreach ($translationValues as $translation) {
                    // Support nested keys
                    if (str_contains($translation->key, '.')) {
                        Arr::set($translations, $translation->key, $translation->value);
                    } else {
                        $translations[$translation->key] = $translation->value;
                    }
                }
                $this->generateFile($language, $fileName, $translations);
            }
        }
    }

    private function generateFile(mixed $language, int|string $fileName, $translations)
    {
        $path = lang_path($language->folder_name);
        $filePath = $path.'/'.$fileName.'.php';
        if (! file_exists($path)) {
            mkdir($path, 0777, true);
        }

        //        if ($fileName === 'passwords') {
        $translations = collect($translations)->map(function ($value, $key) {

            // Check if value contains a special character

            // check if value is string
            //                if (is_string($value)) {
            //                    $value = $this->resolveSpecialCharacters($value);
            //                }

            return $this->resolveSpecialCharacters($value);
        })->toArray();
        //        dd(var_export($translations, true));
        //            die();
        //        }
        $translationArray = var_export($translations, true);

        // Change array() to []
        $translationArray = str_replace('array (', '[', $translationArray);
        $translationArray = str_replace(')', ']', $translationArray);

        // Replace triple backslash with one backslash
        $translationArray = str_replace('\\\\\\', '\\', $translationArray);

        //        if ($fileName === 'passwords') {
        //            dd($translationArray);
        //        }
        //        return;

        //        // replace single quotes with double quotes
        //        $translationArray = str_replace("'", '"', $translationArray);
        //        // replace duplicate double quotes with one double quote
        //        $translationArray = str_replace('""', '"', $translationArray);
        //        if ($fileName === 'passwords') {
        //            dd(explode('=>', $translationArray));
        //        }
        //        return;

        $data = '<?php'.PHP_EOL.'return '.$translationArray.';';
        file_put_contents($filePath, $data);
    }

    private function resolveSpecialCharacters($value)
    {
        if (is_string($value)) {
            if (preg_match('/[\'^£$%&*()}{@#~?><>,|=_+¬-]/', $value)) {
                $value = Str::of($value)->replace("'", "\\'")->value();
                if (Str::startsWith($value, '"')) {
                    $value = Str::replaceFirst('"', '', $value);
                }
                if (Str::endsWith($value, '"') || Str::endsWith($value, '",')) {
                    $value = Str::replaceLast('",', '', $value);
                    $value = Str::replaceLast('"', '', $value);
                }
                //                    if(str::contains($value,"'")) {
                //                        $value = str_replace("'", "\'", $value);
                //                    }
            }
        } else {
            if (is_array($value)) {
                $value = collect($value)->map(function ($value, $key) {
                    return $this->resolveSpecialCharacters($value);
                })->toArray();
            }
        }

        return $value;
    }
}
