import {computed, ref} from "vue";
import {useState} from "@/composables/useState";


export function useModal(formDefault = {}) {
    const {state, isLoading, setStateToIdle, setStateToPending} = useState()

    const active = ref(false)
    const toggleModal = () => {
        active.value = !active.value
        if (!active.value) {
            resetForm()
        }
    }

    const form = ref(formDefault)
    const errorRequest = ref({})
    const resetForm = () => {
        form.value = formDefault
        errorRequest.value = {}
    }

     return {
        state,
        isLoading,
        setStateToPending,
        setStateToIdle,
        active,
        toggleModal,
        form,
        resetForm,
        errorRequest
    }
}
