<?php

namespace Flex\TranslationManager\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TranslationHistory extends Model
{
    protected $guarded = [];

    const UPDATED_AT = null;

    public function translation(): BelongsTo
    {
        $modelClass = config('translation-manager.translation_language_model');

        return $this->belongsTo($modelClass::class);
    }
}
