<?php

namespace Flex\TranslationManager\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Translation extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function language(): BelongsTo
    {
        $modelClass = config('translation-manager.translation_language_model');

        return $this->belongsTo($modelClass);
    }

    public function history(): HasMany
    {
        return $this->hasMany(TranslationHistory::class);
    }
}
