<?php

namespace Flex\TranslationManager\Database\Factories;

use Flex\TranslationManager\Models\Translation;
use Flex\TranslationManager\Models\TranslationHistory;
use Illuminate\Database\Eloquent\Factories\Factory;

class TranslationHistoryFactory extends Factory
{
    protected $model = TranslationHistory::class;

    public function definition()
    {
        return [
            'translation_id' => function () {
                return Translation::factory()->create()->id;
            },
            'previous_translation_value' => $this->faker->text,
            'changed_at' => now(),
        ];
    }
}
