<?php

namespace Flex\TranslationManager\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TranslationKeyController
{
    public function index(Request $request)
    {
        $searchQuery = $request->search ?? '';
        $translationModel = config('translation-manager.translation_model');

        $translationModel = new $translationModel();
        $translationTableName = $translationModel->getTable();
        $translationQuery = DB::table($translationTableName)
            ->select(["{$translationTableName}.key", "{$translationTableName}.file_name"])
            ->distinct();

        if (strlen($searchQuery) > 0) {
            $translationKey = DB::raw("CONCAT({$translationTableName}.file_name, '.', {$translationTableName}.key)");
            $translationQuery->where($translationKey, 'like', "%{$searchQuery}%");
        }

        $translationKeys = $translationQuery->get()
            ->map(function ($translation) {
                return [
                    'key' => $translation->key,
                    'file_name' => $translation->file_name,
                    'display_key' => "{$translation->file_name}.{$translation->key}",
                ];
            });

        $data = [
            'translation_keys' => $translationKeys,
        ];

        return response()->json($data);
    }
}
