<?php

namespace Flex\TranslationManager\Http\Controllers\Api;

class LanguagesController
{
    public function index()
    {
        $locale = config('app.locale');
        if (! $locale) {
            $locale = config('app.fallback_locale');
        }

        $data = config('translation-manager.translation_language_model')::query()
            ->get()
            ->map(function ($language) use ($locale) {
                return [
                    'default_locale' => $language->name === $locale,
                    'id' => $language->id,
                    'name' => $language->name,
                ];
            });

        return response()->json($data);
    }
}
